package com.gingersoft.gsa.cloud.manager.mvp.ui.activity;

import android.content.Intent;
import android.os.Bundle;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.FrameLayout;

import com.gingersoft.gsa.cloud.constans.MealConstant;
import com.gingersoft.gsa.cloud.manager.R2;
import com.gingersoft.gsa.cloud.manager.mvp.ui.fragment.AddAreaFragment;
import com.gingersoft.gsa.cloud.manager.mvp.ui.fragment.AddTableFragment;
import com.gingersoft.gsa.cloud.ui.utils.AnimateUtils;
import com.gingersoft.gsa.cloud.ui.widget.dialog.LoadingDialog;
import com.jess.arms.base.BaseActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.gingersoft.gsa.cloud.manager.di.component.DaggerTableManageComponent;
import com.gingersoft.gsa.cloud.manager.mvp.contract.TableManageContract;
import com.gingersoft.gsa.cloud.manager.mvp.presenter.TableManagePresenter;

import com.gingersoft.gsa.cloud.manager.R;
import com.qmuiteam.qmui.alpha.QMUIAlphaTextView;
import com.qmuiteam.qmui.widget.QMUITopBar;
import com.qmuiteam.qmui.widget.section.QMUIStickySectionLayout;


import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import butterknife.BindView;
import butterknife.OnClick;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 05/13/2020 14:47
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class TableManageActivity extends BaseActivity<TableManagePresenter> implements TableManageContract.View {

    @BindView(R2.id.topbar)
    QMUITopBar mTopBar;
    @BindView(R2.id.section_layout)
    QMUIStickySectionLayout section_layout;

    @BindView(R2.id.tv_add_area)
    QMUIAlphaTextView tv_add_area;
    @BindView(R2.id.tv_add_table)
    QMUIAlphaTextView tv_add_table;

    @BindView(R2.id.frameLayout)
    FrameLayout frameLayout;

    private Fragment mCurrentFragment;
    private AddAreaFragment mAddAreaFragment;
    private AddTableFragment mAddTableFragment;


    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerTableManageComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.activity_table_manage; //如果你不需要框架帮你设置 setContentView(id) 需要自行设置,请返回 0
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {

    }

    @Override
    public void initIntent() {

    }

    @Override
    public void initTopBar() {
        mTopBar.removeAllLeftViews();
        mTopBar.removeAllRightViews();
        if (mCurrentFragment == null) {
            mTopBar.setBackgroundColor(ContextCompat.getColor(this, R.color.theme_color));
            mTopBar.addLeftBackImageButton().setOnClickListener(v -> killMyself());
            mTopBar.setTitle("餐檯管理");
        } else if (mCurrentFragment instanceof AddAreaFragment) {
            Button leftButton = mTopBar.addLeftTextButton("取消", R.id.qmui_topbar_item_left_back);
            leftButton.setTextColor(ContextCompat.getColor(this, R.color.theme_white_color));
            leftButton.setOnClickListener(v -> {
                backTableManage();
            });
            Button rightButton = mTopBar.addRightTextButton("保存", R.id.qmui_dialog_edit_right_icon);
            rightButton.setTextColor(ContextCompat.getColor(this, R.color.theme_white_color));
            rightButton.setOnClickListener(v -> {
                if(mAddAreaFragment.addCondition()) {
                    mPresenter.addArea(mAddAreaFragment.createAddAreaRequest());
                }
            });
            mTopBar.setTitle("添加區域");
        } else if (mCurrentFragment instanceof AddTableFragment) {
            Button leftButton = mTopBar.addLeftTextButton("取消", R.id.qmui_topbar_item_left_back);
            leftButton.setTextColor(ContextCompat.getColor(this, R.color.theme_white_color));
            leftButton.setOnClickListener(v -> {
                backTableManage();
            });
            Button rightButton = mTopBar.addRightTextButton("保存", R.id.qmui_dialog_edit_right_icon);
            rightButton.setTextColor(ContextCompat.getColor(this, R.color.theme_white_color));
            rightButton.setOnClickListener(v -> {
                if(mAddTableFragment.addCondition()) {
                    mPresenter.addTable(mAddTableFragment.createAddTableRequest());
                }
            });
            mTopBar.setTitle("添加餐檯");
        }
    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }

    @OnClick(R2.id.tv_add_area)
    void onClickAddArea() {
        FragmentManager fragmentManager = getSupportFragmentManager();
        FragmentTransaction transaction = fragmentManager.beginTransaction();
        hideFragment(transaction);
        if (mAddAreaFragment == null) {
            addAddAreaFragment(transaction);
        } else {
            showFragment(transaction, mAddAreaFragment);
        }
        transaction.commit();
        AnimateUtils.animateUp(frameLayout, 300);
        initTopBar();
    }

    @OnClick(R2.id.tv_add_table)
    void onClickAddTable() {
        FragmentManager fragmentManager = getSupportFragmentManager();
        FragmentTransaction transaction = fragmentManager.beginTransaction();
        hideFragment(transaction);
        if (mAddTableFragment == null) {
            addAddTableFragment(transaction);
        } else {
            showFragment(transaction, mAddTableFragment);
        }
        transaction.commit();
        AnimateUtils.animateUp(frameLayout, 300);
        initTopBar();
    }

    private void addAddAreaFragment(FragmentTransaction transaction) {
        mAddAreaFragment = AddAreaFragment.newInstance();
        mCurrentFragment = mAddAreaFragment;
        transaction.add(R.id.frameLayout, mAddAreaFragment, AddAreaFragment.class.getName());
    }

    private void addAddTableFragment(FragmentTransaction transaction) {
        mAddTableFragment = AddTableFragment.newInstance();
        mCurrentFragment = mAddTableFragment;
        transaction.add(R.id.frameLayout, mAddTableFragment, AddAreaFragment.class.getName());
    }

    private void hideFragment(FragmentTransaction transaction) {
        if (mAddAreaFragment != null) {
            transaction.hide(mAddAreaFragment);
            AnimateUtils.animateDown(frameLayout, 300);
        }
        if (mAddTableFragment != null) {
            transaction.hide(mAddTableFragment);
            AnimateUtils.animateDown(frameLayout, 300);
        }
    }

    private void showFragment(FragmentTransaction transaction, Fragment fragment) {
        mCurrentFragment = fragment;
        transaction.show(fragment);
    }

    @Override
    public void showLoading(String message) {
        if (message != null)
            LoadingDialog.showDialogForLoading(this, message, true);
        else
            LoadingDialog.showDialogForLoading(this);
    }

    @Override
    public void hideLoading() {
        LoadingDialog.cancelDialogForLoading();
    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.makeText(this, message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }

    @Override
    public void addAreaSuccess() {
        backTableManage();
    }

    @Override
    public void addTableSuccess() {
        backTableManage();
    }


    @Override
    public void onBackPressed() {
        if (mCurrentFragment == null) {
            killMyself();
        } else if (mCurrentFragment instanceof AddAreaFragment || mCurrentFragment instanceof AddTableFragment) {
            backTableManage();
        }
    }

    private void backTableManage(){
        mCurrentFragment = null;
        FragmentManager fragmentManager = getSupportFragmentManager();
        FragmentTransaction transaction = fragmentManager.beginTransaction();
        hideFragment(transaction);
        initTopBar();
    }
}
