package com.gingersoft.gsa.cloud.manager.mvp.ui.fragment;

import android.content.Intent;
import android.graphics.Typeface;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.widget.EditText;
import android.widget.PopupWindow;
import android.widget.TextView;
import android.widget.Toast;

import com.gingersoft.gsa.cloud.manager.R2;
import com.gingersoft.gsa.cloud.manager.mvp.model.bean.request.AddTableRequest;
import com.gingersoft.gsa.cloud.ui.widget.dialog.LoadingDialog;
import com.jess.arms.base.BaseFragment;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.gingersoft.gsa.cloud.manager.di.component.DaggerAddTableComponent;
import com.gingersoft.gsa.cloud.manager.mvp.contract.AddTableContract;
import com.gingersoft.gsa.cloud.manager.mvp.presenter.AddTablePresenter;
import com.gingersoft.gsa.cloud.manager.R;
import com.qmuiteam.qmui.skin.QMUISkinHelper;
import com.qmuiteam.qmui.skin.QMUISkinValueBuilder;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.util.QMUIResHelper;
import com.qmuiteam.qmui.widget.dialog.QMUIBottomSheet;
import com.qmuiteam.qmui.widget.grouplist.QMUICommonListItemView;
import com.qmuiteam.qmui.widget.grouplist.QMUIGroupListView;
import com.qmuiteam.qmui.widget.popup.QMUIPopup;
import com.qmuiteam.qmui.widget.popup.QMUIPopups;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import butterknife.BindView;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 05/14/2020 10:16
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class AddTableFragment extends BaseFragment<AddTablePresenter> implements AddTableContract.View {

    @BindView(R2.id.groupListView)
    QMUIGroupListView mGroupListView;

    private QMUIPopup mNormalPopup;
    private EditText tableNameEditText, peopleNumberEditText, serverchargeEditText, tableSortEditText;
    private String[] mAreas = {"大廳", "酒水", "包廂1", "包廂2"};

    public static AddTableFragment newInstance() {
        AddTableFragment fragment = new AddTableFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerAddTableComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_add_table, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {

        initGroupListView();
    }


    private void initGroupListView() {

        int height = QMUIResHelper.getAttrDimen(mContext, com.qmuiteam.qmui.R.attr.qmui_list_item_height);

        QMUICommonListItemView areaItemView = mGroupListView.createItemView(null,
                "區域",
                "大廳",
                QMUICommonListItemView.HORIZONTAL,
                QMUICommonListItemView.ACCESSORY_TYPE_CHEVRON,
                height);
        areaItemView.setTipPosition(QMUICommonListItemView.TIP_POSITION_RIGHT);

        QMUICommonListItemView tableNameItemView = mGroupListView.createItemView("餐檯名稱");
        tableNameItemView.setAccessoryType(QMUICommonListItemView.ACCESSORY_TYPE_CUSTOM);
        tableNameEditText = new EditText(getActivity());
        tableNameEditText.setHint("必填");
        tableNameEditText.setTextSize(QMUIDisplayHelper.dpToPx(8));
        tableNameEditText.setBackgroundColor(ContextCompat.getColor(mContext, R.color.trans));
        tableNameItemView.addAccessoryCustomView(tableNameEditText);

        ViewGroup.LayoutParams rootViewLp = tableNameEditText.getLayoutParams();
        rootViewLp.width = ViewGroup.LayoutParams.MATCH_PARENT;
        rootViewLp.height = ViewGroup.LayoutParams.WRAP_CONTENT;
        tableNameEditText.setLayoutParams(rootViewLp);

        QMUICommonListItemView peopleNumberItemView = mGroupListView.createItemView("就餐人數");
        peopleNumberItemView.setAccessoryType(QMUICommonListItemView.ACCESSORY_TYPE_CUSTOM);
        peopleNumberEditText = new EditText(getActivity());
        peopleNumberEditText.setHint("必填");
        peopleNumberEditText.setTextSize(QMUIDisplayHelper.dpToPx(8));
        peopleNumberEditText.setBackgroundColor(ContextCompat.getColor(mContext, R.color.trans));
        peopleNumberEditText.setInputType(EditorInfo.TYPE_CLASS_NUMBER);
        peopleNumberItemView.addAccessoryCustomView(peopleNumberEditText);


        QMUICommonListItemView serverchargeItemView = mGroupListView.createItemView("服務費");
        serverchargeItemView.setAccessoryType(QMUICommonListItemView.ACCESSORY_TYPE_CUSTOM);
        serverchargeEditText = new EditText(getActivity());
        serverchargeEditText.setHint("0");
        serverchargeEditText.setTextSize(QMUIDisplayHelper.dpToPx(8));
        serverchargeEditText.setBackgroundColor(ContextCompat.getColor(mContext, R.color.trans));
        serverchargeEditText.setInputType(EditorInfo.TYPE_CLASS_NUMBER);
        serverchargeItemView.addAccessoryCustomView(serverchargeEditText);


        QMUICommonListItemView tableSortItemView = mGroupListView.createItemView("餐桌排序");
        tableSortItemView.setAccessoryType(QMUICommonListItemView.ACCESSORY_TYPE_CUSTOM);
        tableSortEditText = new EditText(getActivity());
        tableSortEditText.setHint("100");
        tableSortEditText.setTextSize(QMUIDisplayHelper.dpToPx(8));
        tableSortEditText.setBackgroundColor(ContextCompat.getColor(mContext, R.color.trans));
        tableSortEditText.setInputType(EditorInfo.TYPE_CLASS_NUMBER);
        tableSortItemView.addAccessoryCustomView(tableSortEditText);
        tableSortItemView.showNewTip(true);
        tableSortItemView.setNewTipImage(R.drawable.ic_delete_bill_method);
        tableSortItemView.setNewTipClick(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showSortTip(v);
            }
        });

        int size = QMUIDisplayHelper.dp2px(mContext, 20);
        QMUIGroupListView.newSection(mContext)
                .setLeftIconSize(size, ViewGroup.LayoutParams.WRAP_CONTENT)
                .addItemView(areaItemView, new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        showAreaBottomSheetList(true, true, false, "所在區域",
                                mAreas, true, false);
                    }
                })
                .addItemView(tableNameItemView, null)
                .addItemView(peopleNumberItemView, null)
                .addItemView(serverchargeItemView, null)
                .addItemView(tableSortItemView, null)
                .setMiddleSeparatorInset(QMUIDisplayHelper.dp2px(mContext, 16), 0)
                .addTo(mGroupListView);
    }


    private void showAreaBottomSheetList(boolean gravityCenter,
                                         boolean addCancelBtn,
                                         boolean withIcon,
                                         CharSequence title,
                                         String[] datas,
                                         boolean allowDragDismiss,
                                         boolean withMark) {
        QMUIBottomSheet.BottomListSheetBuilder builder = new QMUIBottomSheet.BottomListSheetBuilder(getActivity());
        builder.setGravityCenter(gravityCenter)
                .setTitle(title)
                .setAddCancelBtn(addCancelBtn)
                .setAllowDrag(allowDragDismiss)
                .setNeedRightMark(withMark)
                .setOnSheetItemClickListener(new QMUIBottomSheet.BottomListSheetBuilder.OnSheetItemClickListener() {
                    @Override
                    public void onClick(QMUIBottomSheet dialog, View itemView, int position, String tag) {
                        dialog.dismiss();

                    }
                });
        if (withMark) {
            builder.setCheckedIndex(40);
        }
        for (String item : datas) {
            builder.addItem(item);
        }
        builder.build().show();
    }

    private void showSortTip(View v) {
        TextView textView = new TextView(mContext);
        textView.setLineSpacing(QMUIDisplayHelper.dp2px(mContext, 4), 1.0f);
        int padding = QMUIDisplayHelper.dp2px(mContext, 20);
        textView.setPadding(padding, padding, padding, padding);
        textView.setText("默认值為100，數字越小排序\n" + "越靠前！");
        int color = QMUIResHelper.getAttrColor(mContext, R.attr.app_skin_common_title_text_color);
        textView.setTextColor(ArmsUtils.getColor(mContext,R.color.theme_black));
//        QMUISkinValueBuilder builder = QMUISkinValueBuilder.acquire();
//        builder.textColor(R.attr.app_skin_common_title_text_color);
//        QMUISkinHelper.setSkinValue(textView, builder);
//        builder.release();
        mNormalPopup = QMUIPopups.popup(mContext, QMUIDisplayHelper.dp2px(mContext, 250))
                .preferredDirection(QMUIPopup.DIRECTION_BOTTOM)
                .view(textView)
                .edgeProtection(QMUIDisplayHelper.dp2px(mContext, 20))
                .dimAmount(0.6f)
                .animStyle(QMUIPopup.ANIM_GROW_FROM_CENTER)
                .onDismiss(new PopupWindow.OnDismissListener() {
                    @Override
                    public void onDismiss() {
                    }
                })
                .show(v);
    }

    @Override
    public void setData(@Nullable Object data) {

    }

    @Override
    public void showLoading(String message) {
        if (message != null)
            LoadingDialog.showDialogForLoading(mContext, message, true);
        else
            LoadingDialog.showDialogForLoading(mContext);
    }

    @Override
    public void hideLoading() {
        LoadingDialog.cancelDialogForLoading();
    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.makeText(mContext, message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {

    }

    public AddTableRequest createAddTableRequest() {
        AddTableRequest addTableRequest = new AddTableRequest();
        return addTableRequest;
    }

    public boolean addCondition() {
        if (TextUtils.isEmpty(tableNameEditText.getText().toString())) {
            showMessage("請輸入餐檯名稱");
            return false;
        }
        if (TextUtils.isEmpty(peopleNumberEditText.getText().toString())) {
            showMessage("請輸入就餐人數");
            return false;
        }
        return true;
    }
}
