package com.gingersoft.gsa.cloud.main.mvp.model.service;

import com.gingersoft.gsa.cloud.main.mvp.model.bean.BusinessDetailsBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.MainBusinessBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.MainOrderInfoChartBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.PaymentMethodBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.SalesFoodsBean;

import java.util.Map;

import io.reactivex.Observable;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;
import okhttp3.RequestBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;

/**
 * Created by Wyh on 2020/1/10.
 * 首頁和報表
 */
public interface MainReportService {
    //支付分析報表
    @Headers({"Domain-Name: wechat_report"})
    @POST("wx/findPayMode" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<PaymentMethodBean> getPaymentInfo(@Body RequestBody requestBody);

    //銷售分析報表
    @Headers({"Domain-Name: gsa_report"})
    @GET("restaurantOperation/sales/analysis" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<SalesFoodsBean> getSalesReportInfo(@QueryMap Map<String, Object> map);

    //銷售分析報表
    @Headers({"Domain-Name: wechat_report"})
    @POST("wx/findFoodTop" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<SalesFoodsBean> getSalesReportInfo(@Body RequestBody requestBody);


    //營業信息
    @Headers({"Domain-Name: gsa_report"})
    @GET("restaurantOperation/business" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<MainBusinessBean> getRestaurantReport(@Query("restaurantId") String restaurantId);

    //營業詳情
    @Headers({"Domain-Name: gsa_report"})
    @GET("restaurantOperation/business/dtails" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BusinessDetailsBean> getRestaurantDetails(@QueryMap Map<String, String> map);

    //營業金額
    @Headers({"Domain-Name: gsa_report"})
    @GET("restaurantOperation/business/amount" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<MainBusinessBean> getRestaurantAmount(@QueryMap Map<String, String> map);

    @Headers({"Domain-Name: wechat_report"})
    @POST("wx/findOrderInfoChart" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<MainOrderInfoChartBean> getOrderInfoChart(@Body RequestBody requestBody);

    //獲取首頁功能列表
    @GET("user/resource/list" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<String> getRestaurantFunList(@Query("restaurantId") String restaurantId);
}
