package com.joe.print.mvp.ui.adapter;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.Nullable;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.gingersoft.gsa.cloud.print.bean.OrderDetails;
import com.joe.print.R;

import org.w3c.dom.Text;

import java.math.BigDecimal;
import java.util.List;

import static com.qmuiteam.qmui.util.QMUIDisplayHelper.dp2px;
import static com.qmuiteam.qmui.util.QMUIDisplayHelper.px2dp;

public class OtherOrderAdapter extends BaseQuickAdapter<OrderDetails.DataBean.PRODUCTNAMEBean, BaseViewHolder> {
    private Context context;
    private int indentation = 5;
    private boolean isShowPrice;

    public OtherOrderAdapter(Context context, @Nullable List<OrderDetails.DataBean.PRODUCTNAMEBean> data, boolean isShowPrice) {
        super(R.layout.print_other_order_food_item, data);
        this.context = context;
        this.isShowPrice = isShowPrice;
    }

    @Override
    protected void convert(BaseViewHolder helper, OrderDetails.DataBean.PRODUCTNAMEBean item) {
        helper.setText(R.id.tv_food_name, item.getPRODUCT_NAME());
        helper.setText(R.id.tv_food_number, "x" + item.getNum());
        helper.setText(R.id.tv_food_price, item.getPRICE());
        helper.getView(R.id.tv_food_price).setVisibility(isShowPrice ? View.VISIBLE : View.INVISIBLE);

        if (helper.getAdapterPosition() == 0) {
            indentation = px2dp(context, (int) ((TextView) helper.getView(R.id.tv_food_name)).getTextSize());
            Log.e("eee", "寬度：" + indentation);
        }

        if (item.getChild() != null && item.getChild().size() > 0) {
            LinearLayout childLayout = helper.getView(R.id.layout_food_content);
            for (OrderDetails.DataBean.PRODUCTNAMEBean.ChildBeanX childBeanX : item.getChild()) {
                View secondView = getChild(childBeanX.getPRODUCT_NAME(), childBeanX.getNum(), childBeanX.getPRICE(), indentation);
                childLayout.addView(secondView);
                if (childBeanX.getChild() != null && childBeanX.getChild().size() > 0) {
                    LinearLayout secondLayout = secondView.findViewById(R.id.layout_food_content);
                    for (OrderDetails.DataBean.PRODUCTNAMEBean.ChildBeanX.ChildBean childBean : childBeanX.getChild()) {
                        secondLayout.addView(getChild(childBean.getPRODUCT_NAME(), childBean.getNum(), childBean.getPRICE(), indentation * 2));
                    }
                }
            }

        }
    }

    private View getChild(String foodName, String foodNum, String price, int leftMargin) {
        View view = LayoutInflater.from(context).inflate(R.layout.print_other_order_food_item, null, false);
        TextView tvFoodName = view.findViewById(R.id.tv_food_name);
        tvFoodName.setPadding(dp2px(context, leftMargin), 0, 0, 0);
        tvFoodName.setText("-" + foodName);
        ((TextView) view.findViewById(R.id.tv_food_number)).setText("x" + foodNum);
        ((TextView) view.findViewById(R.id.tv_food_price)).setText(price);
        view.findViewById(R.id.tv_food_price).setVisibility(isShowPrice ? View.VISIBLE : View.INVISIBLE);
        return view;
    }


}
