package com.gingersoft.gsa.cloud.table.mvp.presenter;

import android.app.Application;

import com.gingersoft.gsa.cloud.constans.MealConstant;
import com.gingersoft.gsa.cloud.database.bean.ComboItem;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.database.bean.Modifier;
import com.gingersoft.gsa.cloud.table.mvp.contract.SoldoutCtrlContract;
import com.gingersoft.gsa.cloud.table.mvp.ui.activity.SoldoutCtrlActivity;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.CurrentSlodoutFoodAdapter;
import com.gingersoft.gsa.cloud.ui.adapter.meal.ComboAdapter;
import com.gingersoft.gsa.cloud.ui.adapter.meal.FoodAdapter;
import com.gingersoft.gsa.cloud.ui.adapter.meal.FoodGroupAdapter;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.http.imageloader.ImageLoader;
import com.jess.arms.integration.AppManager;
import com.jess.arms.mvp.BasePresenter;

import java.util.ArrayList;
import java.util.List;

import javax.inject.Inject;

import me.jessyan.rxerrorhandler.core.RxErrorHandler;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/22/2020 10:39
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
public class SoldoutCtrlPresenter extends BasePresenter<SoldoutCtrlContract.Model, SoldoutCtrlContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;

    private SoldoutCtrlActivity IActivity;

    private CurrentSlodoutFoodAdapter mCurrentSlodoutFoodAdapter;

    private FoodGroupAdapter mFoodGroupAdapter;
    private FoodAdapter mFoodAdapter;
    private ComboAdapter mComboAdapter;
    //食品数据
    private List<Food> mFoodGroupList = new ArrayList<>();
    private List<Food> mFoodList = new ArrayList<>();
    private List<ComboItem> mFoodComboList = new ArrayList<>();
    //细项数据
    private List<Modifier> mModifierList = new ArrayList<>();

    @Inject
    public SoldoutCtrlPresenter(SoldoutCtrlContract.Model model, SoldoutCtrlContract.View rootView) {
        super(model, rootView);
        this.IActivity = (SoldoutCtrlActivity) rootView;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }

    public void initAdapter() {
//        if (mCurrentSlodoutFoodAdapter == null) {
//            mCurrentSlodoutFoodAdapter = new CurrentSlodoutFoodAdapter(mApplication, mCurrentSlodoutFoodList, GSAApplication.androidSetting.getFoodlListFontSize());
//            mRootView.setCurrentSoldoutFoodAdapter(mCurrentSlodoutFoodAdapter);
//        }
        if (mFoodGroupAdapter == null) {
            mFoodGroupAdapter = new FoodGroupAdapter(mApplication, mFoodGroupList);
            mRootView.setFoodGroupAdapter(mFoodGroupAdapter);
        }
        if (mFoodAdapter == null) {
            mFoodAdapter = new FoodAdapter(mApplication, mFoodList);
            mRootView.setFoodAdapter(mFoodAdapter);
        }
        if (mComboAdapter == null) {
            mComboAdapter = new ComboAdapter(IActivity, mFoodComboList);
            mRootView.setComboAdapter(mComboAdapter);
        }
    }

    public void initFoodListener() {
        mFoodAdapter.setOnItemClickListener(new FoodAdapter.OnItemClickListener() {

            @Override
            public void onItemClick(Food datasBean, int position) {

//                loadComboData(datasBean);

            }
        });
        mComboAdapter.setOnItemClickListener(new ComboAdapter.OnItemClickListener() {

            @Override
            public void onItemClick(ComboItem datasBean, int position) {

            }
        });
    }

    public void initFoodData() {
        List<Food> foodGroupList = mModel.queryDB_FoodGroupList();
        if (foodGroupList != null && foodGroupList.size() > 0) {
            mFoodGroupList.addAll(foodGroupList);
            //默認選中第一組
            mFoodGroupList.get(0).setSelected(true);
            IActivity.initFoodGroupView(mFoodGroupList);
            changedMealByParentId(mFoodGroupList.get(0).getId());
        }
    }

    public void changedMealByParentId(long parentId) {
        List<Food> foodList = mModel.queryDB_FoodList(parentId);
        mFoodAdapter.resetSelect(-1, null);
        if (foodList != null) {
            updateFoodData(foodList);
        }
    }

    private void loadComboData(Food food) {

        long fid = food.getId();

        //获取套餐细项数据
        List<ComboItem> comboItems = mModel.queryDB_ComboList(fid);
        //更新套餐数据
        updateComboData(comboItems);

        mRootView.showViewModeVisibility(MealConstant.combo_ViewMode);
    }

    /**
     * 更新食品數據
     *
     * @param foodList
     */
    private void updateFoodData(List<Food> foodList) {
        mFoodList.clear();
        mFoodList.addAll(foodList);
        //根据Item个数显示每一行的个数
        mRootView.setFoodRecycleSpanCount(mFoodList.size());
        mFoodAdapter.notifyDataSetChanged();
    }

    /**
     * 更新套餐數據
     *
     * @param foodComboList
     */
    private void updateComboData(List<ComboItem> foodComboList) {
        mFoodComboList.clear();
        mFoodComboList.addAll(foodComboList);
        mComboAdapter.notifyDataSetChanged();
    }

}
