package com.gingersoft.gsa.other_order_mode.util

import android.app.Dialog
import android.content.Context
import android.util.Log
import android.widget.Button
import android.widget.TextView
import androidx.databinding.DataBindingUtil
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.gingersoft.gsa.cloud.base.widget.DialogUtils
import com.gingersoft.gsa.cloud.print.bean.OrderDetails
import com.gingersoft.gsa.other_order_mode.R
import com.gingersoft.gsa.other_order_mode.databinding.LayoutOrderInfoDialogBinding
import com.gingersoft.gsa.other_order_mode.databinding.LayoutOrderInfoDialogNewBinding
import com.gingersoft.gsa.other_order_mode.ui.adapter.FoodListAdapter
import com.jess.arms.utils.ArmsUtils

object OtherOrderUtils {

    fun showOrderDetailsDialog(context: Context, data: OrderDetails, orderStuats: Int, orderType: Int, showBtn: Boolean = true, listenter: ((data: OrderDetails.DataBean, dialog: Dialog) -> Unit)?) {
        object : DialogUtils(context, R.layout.layout_order_info_dialog_new) {
            override fun initLayout(hepler: ViewHepler, dialog: Dialog) {
                if (data.data != null) {
                    val tvStatus = hepler.getView<TextView>(R.id.tv_order_state)
                    val orderData = data.data!![0]
                    val layoutOrderInfoDialogBinding: LayoutOrderInfoDialogNewBinding = DataBindingUtil.bind(hepler.contentView)!!
                    layoutOrderInfoDialogBinding.data = orderData
                    layoutOrderInfoDialogBinding.isSelf = orderType == 7
                    layoutOrderInfoDialogBinding.totalAmount = orderData.TOTAL_AMOUNT!!.toDouble()
                    layoutOrderInfoDialogBinding.showBtn = showBtn
                    val btnContent: String
                    val type = if (orderType == 7) "自取" else "外賣"
                    val orderStatus: String
                    when (orderStuats) {
                        2 -> {
                            if (orderType == 7) {
                                //自取
                                btnContent = "製作完成"
                                tvStatus.setTextColor(context.resources.getColor(R.color.order_state0_color))
                            } else {
                                btnContent = "指派送貨"
                                tvStatus.setTextColor(context.resources.getColor(R.color.order_state1_color))
                            }
                            orderStatus = "製作中"
                        }
                        3 -> {
                            btnContent = "結賬"
                            if (orderType == 7) {
                                //自取
                                orderStatus = "待取餐"
                                tvStatus.setTextColor(context.resources.getColor(R.color.order_state3_color))
                            } else {
                                orderStatus = "派送中"
                                tvStatus.setTextColor(context.resources.getColor(R.color.order_state2_color))
                            }
                        }
                        else -> {
                            btnContent = "確認訂單"
                            orderStatus = "待確認"
                            tvStatus.setTextColor(context.resources.getColor(R.color.order_state0_color))
                        }
                    }
                    layoutOrderInfoDialogBinding.orderStatus = type + orderStatus
                    layoutOrderInfoDialogBinding.btnContent = btnContent
                }

                val rvFood: RecyclerView = hepler.getView(R.id.rv_food)
                rvFood.layoutManager = LinearLayoutManager(context)
                rvFood.adapter = FoodListAdapter(context, data.data!![0].PRODUCT_NAME!!)
                hepler.getView<Button>(R.id.btn_assign_shipping).setOnClickListener {
                    //指派送貨或是確認訂單？
                    //確認訂單，調用接口，並打印
                    listenter?.invoke(data.data!![0], dialog)
                }
            }
        }.setWidth((ArmsUtils.getScreenWidth(context) * 0.9).toInt())
                .setHeight((ArmsUtils.getScreenHeidth(context) * 0.8).toInt())
                .createDialogView()
                .show()

    }

}