package com.gingersoft.gsa.cloud.table.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.database.bean.ComboItem;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.database.utils.ComboItemDaoUtils;
import com.gingersoft.gsa.cloud.database.utils.FoodDaoUtils;
import com.gingersoft.gsa.cloud.table.mvp.contract.SoldoutCtrlContract;
import com.google.gson.Gson;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import java.util.List;

import javax.inject.Inject;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/22/2020 10:39
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
public class SoldoutCtrlModel extends BaseModel implements SoldoutCtrlContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public SoldoutCtrlModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public List<Food> queryDB_FoodGroupList() {
        FoodDaoUtils foodDaoUtils = new FoodDaoUtils(mApplication);
        List<Food> foods = foodDaoUtils.queryFoodGroupByQueryBuilder();
        return foods;
    }

    @Override
    public List<Food> queryDB_FoodList(long parentId) {
        FoodDaoUtils foodDaoUtils = new FoodDaoUtils(mApplication);
        List<Food> foods = foodDaoUtils.queryFoodByQueryBuilder(parentId);
        return foods;
    }

    @Override
    public List<ComboItem> queryDB_ComboList(long fid) {
        ComboItemDaoUtils comboItemDao = new ComboItemDaoUtils(mApplication);
        List<ComboItem> foodCombo = comboItemDao.queryComboItemsByFidQueryBuilder(fid);
        return foodCombo;
    }

}