package com.gingersoft.gsa.other_order_mode.data.network

import com.gingersoft.gsa.cloud.globalconfig.applyOptions.intercept.LoggingInterceptor
import okhttp3.OkHttpClient
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import retrofit2.converter.scalars.ScalarsConverterFactory

object ServiceCreator {
    private val httpClient = OkHttpClient.Builder().addInterceptor(LoggingInterceptor())

    private const val ROOT_SZ_URL = "http://192.168.1.74:6060"
    private const val ROOT_HK_TEST_URL = "https://hktest.ricepon.com:64377"
    private const val ROOT_FORMAL_URL = "https://m.ricepon.com"

    const val ROOT_URL = ROOT_HK_TEST_URL

    private const val BASE_URL = "$ROOT_URL/ricepon-wechat/api/"
    private const val BASE_URL2 = "$ROOT_URL/member-web/api/"
    private const val BASE_URL3 = "$ROOT_URL/member-web/ricepon-gsa/api/"


    private val builder = Retrofit.Builder()
            .baseUrl(BASE_URL)
            .client(httpClient.build())
            .addConverterFactory(ScalarsConverterFactory.create())
            .addConverterFactory(GsonConverterFactory.create())

    private val builder2 = Retrofit.Builder()
            .baseUrl(BASE_URL2)
            .client(httpClient.build())
            .addConverterFactory(ScalarsConverterFactory.create())
            .addConverterFactory(GsonConverterFactory.create())

    private val builder3 = Retrofit.Builder()
            .baseUrl(BASE_URL3)
            .client(httpClient.build())
            .addConverterFactory(ScalarsConverterFactory.create())
            .addConverterFactory(GsonConverterFactory.create())

    fun <T> create(serviceClass: Class<T>): T = builder.build().create(serviceClass)

    fun <T> create2(serviceClass: Class<T>): T = builder2.build().create(serviceClass)

    fun <T> create3(serviceClass: Class<T>): T = builder3.build().create(serviceClass)
}