package com.gingersoft.gsa.other_order_mode.data.network.api

import com.gingersoft.gsa.cloud.print.bean.OrderDetails
import com.gingersoft.gsa.other_order_mode.data.model.bean.*
import okhttp3.RequestBody
import retrofit2.Call
import retrofit2.http.Body
import retrofit2.http.POST

interface WeatherService {

    @POST("wechat/findOrderList")
    fun getOrderList(@Body requestBody: RequestBody): Call<OrderList>

    @POST("wx/updateRestOpenStatus")
    fun updateRestOpenStatus(@Body requestBody: RequestBody): Call<MessageBean>

    @POST("wechat/findOrderDetails")
    fun getOrderDesc(@Body requestBody: RequestBody): Call<OrderDetails>

    @POST("wechat/updateOrderStatus")
    fun updateOrderStatus(@Body requestBody: RequestBody): Call<UpdateOrderBean>

    @POST("gsa/shipAnyOrdersNew")
    fun thirdDelivery(@Body requestBody: RequestBody): Call<ThirdSend>

    @POST("wechat/updateSelfOrderStatus")
    fun updateSelfOrderStatus(@Body requestBody: RequestBody): Call<UpdateOrderBean>

    @POST("wechat/findRestDelivery")
    fun getDeliveryInfo(@Body requestBody: RequestBody): Call<DeliveryBean>

    @POST("wechat/findHistoryOrderList")
    fun getHistoryOrderList(@Body requestBody: RequestBody): Call<HistoryOrderBean>
}