package com.gingersoft.supply_chain.mvp.bean;

import com.gingersoft.supply_chain.mvp.content.Constant;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/12/4
 * Time: 11:41
 * Use:食材信息
 */
@Data
public class PurchaseFoodBean implements Serializable {
    private static final long serialVersionUID = 7084280906070243339L;
    private int id;
    private String supplierName;
    private String images;
    private String foodNo;
    private String name;
    /**
     * 單價
     */
    private double unitPrice;
    /**
     * 分類名
     */
    private String foodCategoryName;
    private String remarks;
    private int quantityStarts;
    private int quantityEnd;
    /**
     * 包裝描述：這個字段有值，顯示在採購列表，沒有值，採購列表顯示基本單位
     */
    private String packingDescription;
    private long createTime;
    private int foodQuantity;
    /**
     * 最低採購金額，食品列表用
     */
    private double minimumAmount;
    /**
     * 採購商地址
     */
    private String address;
    /**
     * 分類id
     */
    private int categoryId;
    /**
     * 所屬供應商id
     */
    private int supplierId;
    /**
     * 是否選中
     */
    private boolean isChecked = true;
    /**
     * 是否刪除
     * {@link Constant.DELETE,Constant.NORMAL}
     *
     */
    private int deletes;
    private int restaurantId;
    private int brandId;
    private InventoryAlarm inventoryAlarm;

    /**
     * 庫存預警 模塊
     */
    @Data
    public static class InventoryAlarm {
        /**
         * 是否審核  0否 1是
         */
        private int reviews;
        /**
         * 最低庫存
         */
        private int minimumInventory;
        /**
         * 保質期
         */
        private int shelfLife;
        /**
         * 保質期預警天數
         */
        private int warningDays;
    }

    /**
     * 副單位
     */
    private List<DeputyUnitBean> deputyUnitBeans;

    public boolean isChecked() {
        return isChecked;
    }

    public void setChecked(boolean checked) {
        isChecked = checked;
    }
}
