package com.gingersoft.gsa.cloud.pay.pos.hywebpos.constant;

/**
 * @作者: bin
 * @創建時間: 2020-12-24 9:42
 * @更新時間: 2020-12-24 9:42
 * @描述:
 */
public interface PayMethodConstant {

    /**
     * 支付申请清单
     */
    String PAY_TYPE_CC = "CC"; //信用卡
    String PAY_TYPE_QRC = "QRC";
    String PAY_TYPE_AE = "AE";
    String PAY_TYPE_INTEGRAL = "INTEGRAL";

    //扫码支付
    String PAY_TYPE_QR = "QR";
    String PAY_TYPE_ALP = "ALP";
    String PAY_TYPE_WCP = "WCP";
    /**
     * 付款方式清单
     * <p>
     * VC Visa卡
     * VC-QR Visa卡QR
     * <p>
     * MC 万事达卡
     * MC-QR 万事达卡QR
     * <p>
     * JCB  JCB
     * JCB-QR JCB QR
     * <p>
     * UP 银联
     * UP-QR 银联QR
     * <p>
     * AE AMEX
     * <p>
     * ALP 支付宝
     * WCP 微信支付
     */

    String PAY_WAY_CASH = "CASH"; //现金
    String PAY_WAY_CARD = "CC"; //信用卡
    String PAY_WAY_AE = "AE"; //AMEX
    String PAY_WAY_QR = "QR"; //QR /条码付款（例如VMJ QR，UP QR）
    String PAY_WAY_ALI_WCP = "ALP,WCP"; //微信，支付宝

}
