package com.joe.print.mvp.ui.fragment;

import android.content.Intent;
import android.os.Bundle;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Switch;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.gingersoft.gsa.cloud.constans.Constans;
import com.gingersoft.gsa.cloud.base.utils.other.SPUtils;
import com.jess.arms.base.BaseFragment;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.joe.print.R;
import com.joe.print.R2;
import com.joe.print.di.component.DaggerLocalPrintComponent;
import com.joe.print.di.module.LocalPrintModule;
import com.joe.print.mvp.contract.LocalPrintContract;
import com.joe.print.mvp.presenter.LocalPrintPresenter;

import butterknife.BindView;

import static com.jess.arms.utils.Preconditions.checkNotNull;

/**
 * 本機打印配置頁
 */
public class LocalPrintFragment extends BaseFragment<LocalPrintPresenter> implements LocalPrintContract.View {
    @BindView(R2.id.iv_location_print_btn)
    Switch ivSetLocationPrintBtn;

    public static LocalPrintFragment newInstance() {
        LocalPrintFragment fragment = new LocalPrintFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerLocalPrintComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .localPrintModule(new LocalPrintModule(this))
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_local_print, container, false);
    }

    @Override
    public void onResume() {
        super.onResume();
        initBtn();
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        ivSetLocationPrintBtn.setOnCheckedChangeListener((buttonView, isChecked) -> {
            if(isChecked){
                //修改默認打印方式為本地
                SPUtils.put(mContext, Constans.DEFAULT_PRINT_METHOD, Constans.LOCAL_PRINT);
                ivSetLocationPrintBtn.setChecked(true);
            } else {
                //如果默認打印方式為本地，修改為IP打印
                SPUtils.put(mContext, Constans.DEFAULT_PRINT_METHOD, Constans.IP_PRINT);
                ivSetLocationPrintBtn.setChecked(false);
            }
        });
    }

    private void initBtn() {
        if (SPUtils.get(mContext, Constans.DEFAULT_PRINT_METHOD, "").equals(Constans.LOCAL_PRINT)) {
            //如果默認打印方式為本地
            ivSetLocationPrintBtn.setChecked(true);
        } else {
            ivSetLocationPrintBtn.setChecked(false);
        }
    }

    /**
     * 通过此方法可以使 Fragment 能够与外界做一些交互和通信, 比如说外部的 Activity 想让自己持有的某个 Fragment 对象执行一些方法,
     * 建议在有多个需要与外界交互的方法时, 统一传 {@link Message}, 通过 what 字段来区分不同的方法, 在 {@link #setData(Object)}
     * 方法中就可以 {@code switch} 做不同的操作, 这样就可以用统一的入口方法做多个不同的操作, 可以起到分发的作用
     * <p>
     * 调用此方法时请注意调用时 Fragment 的生命周期, 如果调用 {@link #setData(Object)} 方法时 {@link (Bundle)} 还没执行
     * 但在 {@link #setData(Object)} 里却调用了 Presenter 的方法, 是会报空的, 因为 Dagger 注入是在 {@link (Bundle)} 方法中执行的
     * 然后才创建的 Presenter, 如果要做一些初始化操作,可以不必让外部调用 {@link #setData(Object)}, 在 {@link #initData(Bundle)} 中初始化就可以了
     * <p>
     * Example usage:
     * <pre>
     * public void setData(@Nullable Object data) {
     *     if (data != null && data instanceof Message) {
     *         switch (((Message) data).what) {
     *             case 0:
     *                 loadData(((Message) data).arg1);
     *                 break;
     *             case 1:
     *                 refreshUI();
     *                 break;
     *             default:
     *                 //do something
     *                 break;
     *         }
     *     }
     * }
     *
     * // call setData(Object):
     * Message data = new Message();
     * data.what = 0;
     * data.arg1 = 1;
     * fragment.setData(data);
     * </pre>
     *
     * @param data 当不需要参数时 {@code data} 可以为 {@code null}
     */
    @Override
    public void setData(@Nullable Object data) {

    }

    @Override
    public void showLoading(String message) {

    }

    @Override
    public void hideLoading() {

    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.snackbarText(message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {

    }
}
