package com.gingersoft.gsa.other_order_mode.data

import com.gingersoft.gsa.other_order_mode.data.network.CoolWeatherNetwork
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext
import okhttp3.FormBody

class HistoryOrderRepository private constructor(private val network: CoolWeatherNetwork) {

    suspend fun getHistoryOrderList(restaurantId: String, status: String, pageIndex: String, pageSize: String, orderNo: String = "", phone: String = "") = withContext(Dispatchers.IO) {
        val requestBody = FormBody.Builder()
                .add("restaurantId", restaurantId)
                .add("status", status)
                .add("pageIndex", pageIndex)
                .add("pageSize", pageSize)
                .add("orderNo", orderNo)
                .add("phone", phone)
                .build()
        val heWeather = network.getHistoryOrderList(requestBody)
        heWeather
    }

    suspend fun getOrderInfo(orderId: String) = withContext(Dispatchers.IO) {
        val requestBody = FormBody.Builder()
                .add("orderId", orderId)
                .build()
        val data = network.getOrderInfo(requestBody)
        data
    }

    companion object {
        private lateinit var instance: HistoryOrderRepository

        fun getInstance(network: CoolWeatherNetwork): HistoryOrderRepository {
            if (!::instance.isInitialized) {
                synchronized(HistoryOrderRepository::class.java) {
                    if (!::instance.isInitialized) {
                        instance = HistoryOrderRepository(network)
                    }
                }
            }
            return instance
        }

    }
}