package com.gingersoft.supply_chain.mvp.ui.adapter.dishes;

import android.text.Editable;
import android.text.TextWatcher;
import android.widget.EditText;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.common.utils.toast.ToastUtils;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.DishDetailBean;

import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zjs.
 * 菜品食材綁定列表
 */
public class DishDetailAdapter extends BaseQuickAdapter<DishDetailBean, BaseViewHolder> {

    private List<DishDetailBean> dels=new ArrayList<>();
    public DishDetailAdapter( List<DishDetailBean> foods) {
        super(R.layout.item_dishes_foods,foods);
        addChildClickViewIds(R.id.tv_dishes_unit,R.id.tv_dishes_del);
    }


    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, DishDetailBean item) {
        viewHolder.setText(R.id.tv_dishes_name, item.getFoodName());//食材名字
        viewHolder.setText(R.id.tv_dishes_unit, item.getBasicUnitName());//配置的單位
        final EditText count=viewHolder.getView(R.id.et_dishes_count);
        count.setTag(item);
        count.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {

            }

            @Override
            public void afterTextChanged(Editable s) {
                DishDetailBean tag= (DishDetailBean) count.getTag();
                if (TextUtil.isEmptyOrNullOrUndefined(s)) {
                    ToastUtils.show(getContext(),"數量不能為空");
                    count.setText(String.valueOf(tag.getFoodNumber()));
                    count.setSelection(count.getText().toString().length());
                }else {
                    tag.setFoodNumber(Double.valueOf(s.toString()));
                }
            }
        });
        count.setText(String.valueOf(item.getFoodNumber()));//消耗數量
    }

    public void addDel(DishDetailBean del){
        dels.add(del);
    }

    public List<DishDetailBean> getDels() {
        return dels;
    }

    public void removeDel(DishDetailBean remove){
        for (int i = 0; i < dels.size(); i++) {
            DishDetailBean del=dels.get(i);
            if (remove.getPurchaseFoodId()==del.getPurchaseFoodId()) {
                dels.remove(del);
            }
        }

    }

    public void clearDel(){
        dels.clear();
    }

}
