package com.gingersoft.supply_chain.mvp.ui.adapter.dishes;

import android.view.View;

import androidx.core.content.ContextCompat;

import com.chad.library.adapter.base.entity.node.BaseNode;
import com.chad.library.adapter.base.provider.BaseNodeProvider;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.log.LogUtil;
import com.gingersoft.supply_chain.R;

import org.jetbrains.annotations.NotNull;

public class DishProvider extends BaseNodeProvider {
    @Override
    public int getItemViewType() {
        return DishesTreeAdapter.DISHESSINGLE;
    }

    @Override
    public int getLayoutId() {
        return R.layout.item_dishes;
    }

    @Override
    public void convert(@NotNull BaseViewHolder helper, @NotNull BaseNode data) {
        DishNode entity = (DishNode) data;
        helper.setText(R.id.tv_dish_title, entity.getFoodName());
        if (entity.isSelect()) {
            helper.setTextColor(R.id.tv_dish_title, ContextCompat.getColor(context, R.color.order_category_name_select_color));
        }else {
            helper.setTextColor(R.id.tv_dish_title, ContextCompat.getColor(context, R.color.color_18));
        }

    }

    @Override
    public void onClick(@NotNull BaseViewHolder helper, @NotNull View view, BaseNode data, int position) {
        DishNode entity = (DishNode) data;
        if (entity.isExpanded()) {
            getAdapter().collapse(position);
        } else {
            getAdapter().expandAndCollapseOther(position);
        }

    }
}